/* Wiktor Zychla, 2003 */
using System;
using System.Windows.Forms;

namespace Example
{
  public class MyComboBoxItem
  {
    string text;
    int    id;

    public string Text
    {
      get { return text; }
    }

    public int ID
    {
      get { return id; }
    }

    public MyComboBoxItem( string text, int id )
    {
      this.text = text;
      this.id   = id;
    }
   
    public override string ToString()
    {
      return text;
    }  
  }

  public class CMainForm : Form
  {   
    ComboBox cbItems;

    public CMainForm()
    {
      cbItems = new ComboBox();
      cbItems.Items.Add( new MyComboBoxItem( "ala",  17 ) );
      cbItems.Items.Add( new MyComboBoxItem( "ma",   24 ) );
      cbItems.Items.Add( new MyComboBoxItem( "kota", 19 ) );
      cbItems.Items.Add( new MyComboBoxItem( "!",    78 ) );
      cbItems.SelectedIndexChanged += 
        new EventHandler( cbItems_SelectedIndexChanged );

      this.Controls.Add( cbItems );
    } 

    void cbItems_SelectedIndexChanged( object sender, EventArgs e )
    {
      if ( cbItems.SelectedItem != null )
      {
        MyComboBoxItem myItem = cbItems.SelectedItem as MyComboBoxItem;
        MessageBox.Show( String.Format( "Wybrano element: {0} - {1}",
                            myItem.Text, myItem.ID ) );
      }
    }

    public static void Main()
    {
      Application.Run( new CMainForm() );
    }
  }
}
